InGameMenuSettingsFrameExtension = {}
local InGameMenuSettingsFrameExtension_mt = Class(InGameMenuSettingsFrameExtension)
InGameMenuSettingsFrameExtension.priceMultiplierValues = {0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0}
InGameMenuSettingsFrameExtension.minDurationValues = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24}

function InGameMenuSettingsFrameExtension.new()
    local self = setmetatable({}, InGameMenuSettingsFrameExtension_mt)

    self.settings = {}
    self:init()

    FSBaseMission.sendInitialClientState = Utils.appendedFunction(FSBaseMission.sendInitialClientState, InGameMenuSettingsFrameExtension.sendInitialClientState)
    InGameMenuSettingsFrame.updateGameSettings = Utils.appendedFunction(InGameMenuSettingsFrame.updateGameSettings, InGameMenuSettingsFrameExtension.updateGameSettings)

    return self
end

function InGameMenuSettingsFrameExtension:init()
    local settingsPage = g_inGameMenu.pageSettings
	local scrollPanel = settingsPage.gameSettingsLayout

    for _, element in pairs(scrollPanel.elements) do
		if element.name == "sectionHeader" then
            self.sectionHeader = element:clone(scrollPanel)
        end

		if element.typeName == "Bitmap" then
			if element.elements[1].typeName == "MultiTextOption" then
                self.multiTextOptionElement = element
            end
		end

        if self.sectionHeader ~= nil and self.multiTextOptionElement ~= nil then
            break
        end	
	end

	self.sectionHeader:setText(g_i18n:getText("settings_sectionHeader"))

    for _, setting in pairs(InGameMenuSettingsFrameExtension.Settings) do
        local template = self.multiTextOptionElement:clone(scrollPanel)
        local element = template.elements[1]
        template.id = nil

        template.elements[2]:setText(g_i18n:getText(setting.title))

        element.elements[1]:setText(g_i18n:getText(setting.tooltip))
        element.id = setting.id
        element.onClickCallback = setting.callbackFunction

        local values = {}
        for _, value in pairs(setting.values) do
            local entry = string.format(setting.valueFormatting, value)

            if setting.valueUnit ~= nil then
                entry = entry..setting.valueUnit
            end

            table.insert(values, entry)
        end
        element:setTexts(values)

        table.insert(self.settings, element)

        template:setVisible(true)
        template:setDisabled(false)
    end

	scrollPanel:invalidateLayout()
end

function InGameMenuSettingsFrameExtension.sendInitialClientState(_, connection, user, farm)
    connection:sendEvent(FieldLeasingSettingsEvent.new())
end

function InGameMenuSettingsFrameExtension.updateGameSettings(settingsPage)
    for _, setting in pairs(InGameMenuSettingsFrameExtension.Settings) do
        local settingElement = g_InGameMenuSettingsFrameExtension:getSetting(setting.id)

        for index, value in ipairs(setting.values) do
            if setting.id == "priceMultiplierId" and value == g_fieldLeasingManager.priceMultiplier then
                settingElement:setState(index)
                break
            end
            if setting.id == "minDurationId" and value == g_fieldLeasingManager.minDuration then
                settingElement:setState(index)
                break
            end
        end
    end
end

function InGameMenuSettingsFrameExtension.priceMultiplierChanged(_, state)
    g_fieldLeasingManager:updatePriceMultiplier(InGameMenuSettingsFrameExtension.priceMultiplierValues[state])
end

function InGameMenuSettingsFrameExtension.minDurationChanged(_, state)
    g_fieldLeasingManager:updateMinDuration(InGameMenuSettingsFrameExtension.minDurationValues[state])
end

function InGameMenuSettingsFrameExtension:getSetting(settingId)
    for _, setting in pairs(self.settings) do
        if setting.id == settingId then
            return setting
        end
    end

    Logging.error("InGameMenuSettingsFrameExtension: Could not find setting with id: "..settingId)
    return nil
end

InGameMenuSettingsFrameExtension.Settings = {
    priceMultiplier = {
        id = "priceMultiplierId",
        title = "settings_priceMultiplierTitle",
        tooltip = "settings_priceMultiplierTooltip",
        values = InGameMenuSettingsFrameExtension.priceMultiplierValues,
        callbackFunction = InGameMenuSettingsFrameExtension.priceMultiplierChanged,
        valueFormatting = "%.1f",
        valueUnit = " %"
    },
    minDuration = {
        id = "minDurationId",
        title = "settings_minDurationTitle",
        tooltip = "settings_minDurationTooltip",
        values = InGameMenuSettingsFrameExtension.minDurationValues,
        callbackFunction = InGameMenuSettingsFrameExtension.minDurationChanged,
        valueFormatting = "%d"
    }
}

g_InGameMenuSettingsFrameExtension = InGameMenuSettingsFrameExtension.new()